<?php
/**
 * POST /api/changes.php — Change detection feed
 * Public, rate limited. Returns recent site changes.
 */
require_once __DIR__ . '/../includes/security.php';
$cfg = require __DIR__ . '/../includes/config.php';
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Allow GET for RSS-style access
} else {
    Security::requirePost();
}
if (!Security::checkRate(Security::clientIp(), $cfg['rate_limit'], $cfg['rate_window_sec'])) {
    Security::json(['error' => 'Rate limited'], 429);
}
$db = DB::get();
$input = json_decode(file_get_contents('php://input'), true) ?: array_merge($_POST, $_GET);
$days  = min(30, max(1, intval($input['days'] ?? 1)));
$type  = $input['type'] ?? '';
$limit = min(200, max(1, intval($input['limit'] ?? 50)));

$where = ["c.detected_at >= DATE_SUB(NOW(), INTERVAL ? DAY)"];
$params = [$days];
if ($type && in_array($type, ['title_changed','came_online','went_offline','new_pages','content_changed','canary_changed'])) {
    $where[] = "c.change_type = ?"; $params[] = $type;
}
$ws = implode(' AND ', $where);
$params[] = $limit;

$st = $db->prepare(
    "SELECT c.*, o.title, o.status, o.cti_type
     FROM site_changes c
     LEFT JOIN onions o ON o.address = c.address
     WHERE $ws ORDER BY c.detected_at DESC LIMIT ?"
);
$st->execute($params);
$changes = $st->fetchAll();

// Stats
$st2 = $db->prepare("SELECT change_type, COUNT(*) as cnt FROM site_changes WHERE detected_at >= DATE_SUB(NOW(), INTERVAL ? DAY) GROUP BY change_type");
$st2->execute([$days]);
$stats = [];
foreach ($st2->fetchAll() as $r) $stats[$r['change_type']] = (int)$r['cnt'];

Security::json(['changes' => $changes, 'stats' => $stats, 'days' => $days]);
