<?php
/**
 * GET /api/stats
 * Public endpoint — returns index statistics.
 */

require_once __DIR__ . '/../includes/security.php';

$db = DB::get();

$stats = [];
$stats['total']   = (int) $db->query("SELECT COUNT(*) FROM onions")->fetchColumn();
$stats['online']  = (int) $db->query("SELECT COUNT(*) FROM onions WHERE status='online'")->fetchColumn();
$stats['offline'] = (int) $db->query("SELECT COUNT(*) FROM onions WHERE status='offline'")->fetchColumn();
$stats['pages']   = (int) $db->query("SELECT COUNT(*) FROM pages")->fetchColumn();
$stats['blocked'] = (int) $db->query("SELECT COUNT(*) FROM blocklist")->fetchColumn();

Security::json($stats);
